% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotModel.R
\name{plotModel}
\alias{plotModel}
\title{Plot the model}
\usage{
plotModel(objXAI, modelName, xFeature, yFeature = "")
}
\arguments{
\item{objXAI}{The ObjXAI object created with the XAItest function}

\item{modelName}{The name of the model, can be found in
'names(objXAI@models)'}

\item{xFeature}{The x feature}

\item{yFeature}{The y feature}
}
\value{
A plot
}
\description{
This function plots the model.
}
\examples{

data(iris)
iris = subset(iris, Species == "setosa" | Species == "versicolor")
iris$Species = as.character(iris$Species)
objXAI <- XAI.test(iris, y = "Species")
plotModel(objXAI, "RF_feat_imp", "Sepal.Length", "Sepal.Width")

}
