% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vmat.R
\name{plotVmat.default}
\alias{plotVmat.default}
\title{A function to plot a computed Vmat}
\usage{
\method{plotVmat}{default}(
  x,
  hm = 90,
  colors = COLORSCALE_VMAT,
  breaks = NULL,
  xlim = c(-250, 250),
  ylim = c(50, 300),
  main = "",
  xlab = "Distance from center of elements",
  ylab = "Fragment length",
  key = "Score",
  ...
)
}
\arguments{
\item{x}{A computed Vmat (ideally, should be normalized)}

\item{hm}{Integer, should be between 0 and 100. 
Used to automatically
scale the range of colors (best to 
keep between 90 and 100)}

\item{colors}{a vector of colors}

\item{breaks}{a vector of breaks. 
length(breaks) ==  length(colors) + 1}

\item{xlim}{vector of two integers, x limits}

\item{ylim}{vector of two integers, y limits}

\item{main}{character, title of the plot}

\item{xlab}{character, x-axis label}

\item{ylab}{character, y-axis label}

\item{key}{character, legend label}

\item{...}{additional parameters}
}
\value{
A Vmat ggplot
}
\description{
The default plotVmat method generates a ggplot representing a 
heatmap of fragment density.
}
\examples{
data(bam_test)
data(ce11_proms)
V <- plotVmat(
    bam_test,
    ce11_proms,
    normFun = 'libdepth+nloci', 
    return_Vmat = TRUE
)
plotVmat(V)
}
