% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-univar-downstream.R
\name{moranPlot}
\alias{moranPlot}
\title{Use ggplot to plot the moran.plot results}
\usage{
moranPlot(
  sfe,
  feature,
  graphName = 1L,
  sample_id = "all",
  contour_color = "cyan",
  color_by = NULL,
  colGeometryName = NULL,
  annotGeometryName = NULL,
  plot_singletons = TRUE,
  binned = FALSE,
  filled = FALSE,
  divergent = FALSE,
  diverge_center = NULL,
  swap_rownames = NULL,
  bins = 100,
  binwidth = NULL,
  hex = FALSE,
  plot_influential = TRUE,
  bins_contour = NULL,
  name = "moran.plot",
  ...
)
}
\arguments{
\item{sfe}{A \code{SpatialFeatureExperiment} object.}

\item{feature}{Name of one variable to show on the plot. It will be converted
to sentence case on the x axis and lower case in the y axis appended after
"Spatially lagged". One feature at a time since the colors in
\code{color_by} may be specific to this feature (e.g. from
\code{\link{clusterMoranPlot}}).}

\item{graphName}{Name of the \code{colGraph} or \code{annotGraph}, the
spatial neighborhood graph used to compute the Moran plot. This is to
determine which points are singletons to plot differently on this plot.}

\item{sample_id}{One sample_id for the sample whose graph to plot.}

\item{contour_color}{Color of the point density contours, which can be
changed so the contours stand out from the points.}

\item{color_by}{Variable to color the points by. It can be the name of a
column in colData, a gene, or the name of a column in the colGeometry
specified in colGeometryName. Or it can be a vector of the same length as
the number of cells/spots in the sample_id of interest.}

\item{colGeometryName}{Name of a \code{colGeometry} \code{sf} data frame
whose numeric columns of interest are to be used to compute the metric. Use
\code{\link{colGeometryNames}} to look up names of the \code{sf} data
frames associated with cells/spots.}

\item{annotGeometryName}{Name of a \code{annotGeometry} of the SFE object, to
annotate the gene expression plot.}

\item{plot_singletons}{Logical, whether to plot items that don't have spatial
neighbors.}

\item{binned}{Logical, whether to plot 2D histograms. This argument has
precedence to \code{filled}.}

\item{filled}{Logical, whether to plot filled contours for the
non-influential points and only plot influential points as points.}

\item{divergent}{Logical, whether a divergent palette should be used.}

\item{diverge_center}{If \code{divergent = TRUE}, the center from which the
palette should diverge. If \code{NULL}, then not centering.}

\item{swap_rownames}{Column name of \code{rowData(object)} to be used to
identify features instead of \code{rownames(object)} when labeling plot
elements. If not found in \code{rowData}, then rownames of the gene count
matrix will be used.}

\item{bins}{If binning the \code{colGeometry} in space due to large number of
cells or spots, the number of bins, passed to \code{\link{geom_bin2d}} or
\code{\link{geom_hex}}. If \code{NULL} (default), then the
\code{colGeometry} is plotted without binning. If binning, a point geometry
is recommended. If the geometry is not point, then the centroids will be
used.}

\item{binwidth}{Width of bins, passed to \code{\link{geom_bin2d}} or
\code{\link{geom_hex}}.}

\item{hex}{Logical, whether to use \code{\link{geom_hex}}. Note that
\code{geom_hex} is broken in \code{ggplot2} version 3.4.0. Please update
\code{ggplot2} if you are getting horizontal stripes when \code{hex =
TRUE}.}

\item{plot_influential}{Logical, whether to plot influential points with
different palette if \code{binned = TRUE}.}

\item{bins_contour}{Number of bins in the point density contour. Use a
smaller number to make sparser contours.}

\item{name}{Name under which the Moran plot results are stored. By default
"moran.plot".}

\item{...}{Other arguments to pass to \code{\link{geom_density2d}}.}
}
\value{
A ggplot object.
}
\description{
This function uses \code{ggplot2} to plot the Moran plot. The plot would be
more aesthetically pleasing than the base R version implemented in
\code{spdep}. In addition, contours are plotted to show point density on the
plot, and the points can be colored by a variable, such as clusters. The
contours may also be filled and only influential points plotted. When filled,
the viridis E option is used.
}
\examples{
library(SpatialFeatureExperiment)
library(SingleCellExperiment)
library(SFEData)
library(bluster)
library(scater)
sfe <- McKellarMuscleData("full")
sfe <- sfe[, colData(sfe)$in_tissue]
sfe <- logNormCounts(sfe)
colGraph(sfe, "visium") <- findVisiumGraph(sfe)
sfe <- runUnivariate(sfe, type = "moran.plot", features = "Myh1",
                     swap_rownames = "symbol")
clust <- clusterMoranPlot(sfe, "Myh1", BLUSPARAM = KmeansParam(2),
                          swap_rownames = "symbol")
moranPlot(sfe, "Myh1", graphName = "visium", color_by = clust[, 1],
          swap_rownames = "symbol")
}
\concept{Plot spatial analysis results}
