% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate-downstream.R
\name{clusterCorrelograms}
\alias{clusterCorrelograms}
\title{Find clusters of correlogram patterns}
\usage{
clusterCorrelograms(
  sfe,
  features,
  BLUSPARAM,
  sample_id = "all",
  method = "I",
  colGeometryName = NULL,
  annotGeometryName = NULL,
  reducedDimName = NULL,
  swap_rownames = NULL,
  name = "sp.correlogram"
)
}
\arguments{
\item{sfe}{A \code{SpatialFeatureExperiment} object with correlograms
computed for features of interest.}

\item{features}{Features whose correlograms to cluster.}

\item{BLUSPARAM}{A \linkS4class{BlusterParam} object specifying the algorithm to use.}

\item{sample_id}{Sample(s) in the SFE object whose cells/spots to use. Can be
"all" to compute metric for all samples; the metric is computed separately
for each sample.}

\item{method}{"corr" for correlation, "I" for Moran's I, "C" for Geary's C}

\item{colGeometryName}{Name of colGeometry from which to look for features.}

\item{annotGeometryName}{Name of annotGeometry from which to look for
features.}

\item{reducedDimName}{Name of a dimension reduction, can be seen in
\code{\link[SingleCellExperiment]{reducedDimNames}}. \code{colGeometryName} and
\code{annotGeometryName} have precedence over \code{reducedDimName}.}

\item{swap_rownames}{Column name of \code{rowData(object)} to be used to
identify features instead of \code{rownames(object)} when labeling plot
elements. If not found in \code{rowData}, then rownames of the gene count
matrix will be used.}

\item{name}{Name under which the correlogram results are stored, which is by
default "sp.correlogram".}
}
\value{
A data frame with 3 columns: \code{feature} for the features,
  \code{cluster} a factor for cluster membership of the features within each
  sample, and \code{sample_id} for the sample.
}
\description{
Cluster the correlograms to find patterns in length scales of spatial
autocorrelation. All the correlograms clustered must be computed with the
same method and have the same number of lags. Correlograms are clustered
jointly across samples.
}
\examples{
library(SpatialFeatureExperiment)
library(SFEData)
library(bluster)
sfe <- McKellarMuscleData("small")
colGraph(sfe, "visium") <- findVisiumGraph(sfe)
inds <- c(1, 3, 4, 5)
sfe <- runUnivariate(sfe,
    type = "sp.correlogram",
    features = rownames(sfe)[inds],
    exprs_values = "counts", order = 5
)
clust <- clusterCorrelograms(sfe,
    features = rownames(sfe)[inds],
    BLUSPARAM = KmeansParam(2)
)
}
\concept{Downstream analyses of univariate spatial results}
