% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bivariate.R
\name{calculateBivariate}
\alias{calculateBivariate}
\alias{calculateBivariate,ANY-method}
\alias{calculateBivariate,SpatialFeatureExperiment-method}
\alias{runBivariate}
\title{Bivariate spatial statistics}
\usage{
\S4method{calculateBivariate}{ANY}(
  x,
  y = NULL,
  type,
  listw = NULL,
  coords_df = NULL,
  BPPARAM = SerialParam(),
  zero.policy = NULL,
  returnDF = TRUE,
  p.adjust.method = "BH",
  name = NULL,
  ...
)

\S4method{calculateBivariate}{SpatialFeatureExperiment}(
  x,
  type,
  feature1,
  feature2 = NULL,
  colGraphName = 1L,
  colGeometryName = 1L,
  sample_id = "all",
  exprs_values = "logcounts",
  BPPARAM = SerialParam(),
  zero.policy = NULL,
  returnDF = TRUE,
  p.adjust.method = "BH",
  swap_rownames = NULL,
  name = NULL,
  ...
)

runBivariate(
  x,
  type,
  feature1,
  feature2 = NULL,
  colGraphName = 1L,
  colGeometryName = 1L,
  sample_id = "all",
  exprs_values = "logcounts",
  BPPARAM = SerialParam(),
  swap_rownames = NULL,
  zero.policy = NULL,
  p.adjust.method = "BH",
  name = NULL,
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{x}{A numeric matrix whose rows are features/genes, or a numeric vector
(then \code{y} must be specified), or a \code{SpatialFeatureExperiment}
(SFE) object with such a matrix in an assay.}

\item{y}{A numeric matrix whose rows are features/genes, or a numeric vector.
Bivariate statics will be computed for all pairwise combinations of row
names of x and row names of y, except in cross variogram where combinations
within x and y are also computed.}

\item{type}{An \code{\link{SFEMethod}} object, or a string matching the name
of an \code{SFEMethod} object. The methods mentioned above correspond to
\code{SFEMethod} objects already implemented in the Voyager package. Use
\code{\link{listSFEMethods}} to see which methods are available. You can
implement new \code{SFEMethod} objects to apply Voyager functions to other
spatial analysis methods. This is in part inspired by the \code{caret},
\code{parsnip}, and \code{BiocSingular} packages.}

\item{listw}{Weighted neighborhood graph as a \code{spdep} \code{listw}
object. Not used when the method specified in \code{type} does not use a
spatial neighborhood graph, such as the variogram.}

\item{coords_df}{A \code{sf} data frame specifying location of each cell. Not
used when the method specified in \code{type} uses a spatial neighborhood
graph. Must be specified otherwise.}

\item{BPPARAM}{A \code{\link{BiocParallelParam}} object specifying whether
and how computing the metric for numerous genes shall be parallelized.}

\item{zero.policy}{default \code{attr(listw, "zero.policy")} as set when \code{listw} was created, if attribute not set, use global option value; if TRUE assign zero to the lagged value of zones without neighbours, if FALSE assign NA}

\item{returnDF}{Logical, when the results are not added to a SFE object,
whether the results should be formatted as a \code{DataFrame}.}

\item{p.adjust.method}{Method to correct for multiple testing, passed to
\code{\link[spdep]{p.adjustSP}}. Methods allowed are in
\code{\link{p.adjust.methods}}.}

\item{name}{Name to use to store the results, defaults to the name in the
\code{SFEMethod} object passed to argument \code{type}. Can be set to
distinguish between results from the same method but with different
parameters.}

\item{...}{Other arguments passed to S4 method (for convenience wrappers like
\code{calculateMoransI}) or method used to compute metrics as specified by
the argument \code{type} (as in more general functions like
\code{calculateUnivariate}). See documentation of functions with the same
name as specified in \code{type} in the \code{spdep} package for the method
specific arguments. For variograms, see \code{\link{.variogram}}.}

\item{feature1}{ID or symbol of the first genes in SFE object, for the
argument \code{x}.}

\item{feature2}{ID or symbol of the second genes in SFE object, for the
argument \code{x}. Mandatory if length of \code{feature1} is 1.}

\item{colGraphName}{Name of the listw graph in the SFE object that
corresponds to entities represented by columns of the gene count matrix.
Use \code{\link{colGraphNames}} to look up names of the available graphs
for cells/spots. Note that for multiple \code{sample_id}s, it is assumed
that all of them have a graph of this same name.}

\item{colGeometryName}{Name of a \code{colGeometry} \code{sf} data frame
whose numeric columns of interest are to be used to compute the metric. Use
\code{\link{colGeometryNames}} to look up names of the \code{sf} data
frames associated with cells/spots. In the SFE method of
\code{calculateUnivariate}, this is to specify location of cells for
methods that don't take a spatial neighborhood graph such as the variogram.
If the geometry is not of type \code{POINT}, then \code{spatialCoords(x)}
is used instead.}

\item{sample_id}{Sample(s) in the SFE object whose cells/spots to use. Can be
"all" to compute metric for all samples; the metric is computed separately
for each sample.}

\item{exprs_values}{Integer scalar or string indicating which assay of x
contains the expression values.}

\item{swap_rownames}{Column name of \code{rowData(object)} to be used to
identify features instead of \code{rownames(object)} when labeling plot
elements. If not found in \code{rowData}, then rownames of the gene count
matrix will be used.}

\item{overwrite}{Logical, whether to overwrite existing results with the same
name. Defaults to \code{FALSE}.}
}
\value{
The \code{calculateBivariate} function returns a correlation matrix
  for global Lee, and the results for the each pair of genes for other
  methods. Global results are not stored in the SFE object. Some methods
  return one result for each pair of genes, while some return pairwise
  results for more than 2 genes jointly. Local results are stored in the
  \code{\link{localResults}} field in the SFE object, with name the
  concatenation the two gene names separated by two underscores (\code{__}).
}
\description{
These functions perform bivariate spatial analysis. In this version, the
bivariate global method supported are \code{\link{lee}},
\code{\link{lee.mc}}, and \code{\link{lee.test}} from \code{spdep}, and cross
variograms from \code{gstat} (use \code{cross_variogram} and
\code{cross_variogram_map} for \code{type} argument, see
\code{\link{variogram-internal}}). Global Lee statistic is computed by my own
implementation that is much faster than that in \code{spdep}. Bivariate local
methods supported are \code{\link{lee}} (use \code{locallee} for \code{type}
argument) and \code{\link{localmoran_bv}} a bivariate version of Local Moran
in \code{spdep}.
}
\examples{
library(SFEData)
library(scater)
library(scran)
library(SpatialFeatureExperiment)
library(SpatialExperiment)
sfe <- McKellarMuscleData()
sfe <- sfe[,sfe$in_tissue]
sfe <- logNormCounts(sfe)
gs <- modelGeneVar(sfe)
hvgs <- getTopHVGs(gs, fdr.threshold = 0.01)
g <- colGraph(sfe, "visium") <- findVisiumGraph(sfe)

# Matrix method
mat <- logcounts(sfe)[hvgs[1:5],]
df <- df2sf(spatialCoords(sfe), spatialCoordsNames(sfe))
out <- calculateBivariate(mat, type = "lee", listw = g)
out <- calculateBivariate(mat, type = "cross_variogram", coords_df = df)

# SFE method
out <- calculateBivariate(sfe, type = "lee",
feature1 = c("Myh1", "Myh2", "Csrp3"), swap_rownames = "symbol")
out2 <- calculateBivariate(sfe, type = "lee.test", feature1 = "Myh1",
feature2 = "Myh2", swap_rownames = "symbol")
sfe <- runBivariate(sfe, type = "locallee", feature1 = "Myh1",
feature2 = "Myh2", swap_rownames = "symbol")
}
\concept{Spatial statistics}
