% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/available_organisms.R
\name{available_organisms}
\alias{available_organisms}
\alias{available_organisms,genomic_ressource-method}
\title{Display available organisms from a specified database.}
\usage{
available_organisms(object)

\S4method{available_organisms}{genomic_ressource}(object)
}
\arguments{
\item{object}{a  \code{\link{genomic_ressource-class}} object created by \code{\link{Bioconductor2GO}}, \code{\link{EntrezGene2GO}},
\code{\link{Ensembl2GO}},or \code{\link{Uniprot2GO}} methods.}
}
\value{
javascript datatable
}
\description{
Display an interactive table with available organisms from a genomic ressource database (Bioconductor, EntrezGene, Ensembl, Uniprot).
}
\details{
an interactive \code{datatable}.
}
\examples{
# display Bioconductor table
Bioconductor<-ViSEAGO::Bioconductor2GO()
ViSEAGO::available_organisms(Bioconductor)
\dontrun{

# display EntrezGene table
EntrezGene<-ViSEAGO::EntrezGene2GO()
ViSEAGO::available_organisms(EntrezGene)

# display Ensembl table
Ensembl<-ViSEAGO::Ensembl2GO()
ViSEAGO::available_organisms(Ensembl)

# display Uniprot table
Uniprot<-ViSEAGO::Uniprot2GO()
ViSEAGO::available_organisms(Uniprot)
}
}
\references{
Yihui Xie (2016). DT: A Wrapper of the JavaScript Library 'DataTables'. R package version 0.2. https://CRAN.R-project.org/package=DT
}
\seealso{
Other genomic_ressource: 
\code{\link{Bioconductor2GO}()},
\code{\link{Custom2GO}()},
\code{\link{Ensembl2GO}()},
\code{\link{EntrezGene2GO}()},
\code{\link{Uniprot2GO}()},
\code{\link{annotate}()},
\code{\link{genomic_ressource-class}},
\code{\link{taxonomy}()}

Other visualization: 
\code{\link{GOclusters_heatmap}()},
\code{\link{GOcount}()},
\code{\link{GOterms_heatmap}()},
\code{\link{Upset}()},
\code{\link{overLapper}()},
\code{\link{show_heatmap}()},
\code{\link{show_table}()}
}
\concept{genomic_ressource}
\concept{visualization}
