% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/hmm-methods.R,
%   R/methods-ArrayViews.R
\name{hmm2}
\alias{hmm2}
\alias{hmm2,SnpArrayExperiment-method}
\alias{hmm2,oligoSnpSet-method}
\alias{hmm2,ArrayViews-method}
\title{Fit a 6-state HMM to log R ratios and B allele frequencies
estimated from SNP arrays}
\usage{
hmm2(
  object,
  emission_param = EmissionParam(),
  transition_param = TransitionParam(),
  ...
)

\S4method{hmm2}{SnpArrayExperiment}(
  object,
  emission_param = EmissionParam(),
  transition_param = TransitionParam(),
  ...
)

\S4method{hmm2}{oligoSnpSet}(
  object,
  emission_param = EmissionParam(),
  transition_param = TransitionParam(),
  ...
)

\S4method{hmm2}{ArrayViews}(
  object,
  emission_param = EmissionParam(),
  transition_param = TransitionParam(),
  tolerance = 2,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{object}{A \code{\link{SnpArrayExperiment}}}

\item{emission_param}{A \code{\link{EmissionParam}} object}

\item{transition_param}{A \code{\link{TransitionParam}} object}

\item{...}{currently ignored}

\item{tolerance}{length-one numeric vector.  When the difference in
the log-likelihood of the Viterbi state path between successive
models (updated by Baum Welch) is less than the tolerance, no
additional model updates are performed.}

\item{verbose}{logical.  Whether to display messages indicating progress.}
}
\description{
This function is intended for estimating the integer copy number
from germline or DNA of clonal origin using a 6-state HMM.  The
states are homozygous deletion, hemizygous deletion, diploid copy
number, diploid region of homozygosity, single copy gain, and two+
copy gain.  Because heterozygous markers are more informative for
copy number than homozygous markers and regions of homozgosity are
common in normal genomes, we currently computed a weighted average
of the BAF emission matrix with a uniform 0,1 distribution by the
probability that the marker is heterozygous, thereby downweighting
the contribution of homozygous SNPs to the likelihood.  In addition
to making the detection of copy-neutral regions of homozgosity less
likely, it also helps prevent confusing hemizygous deletions with
copy neutral regions of homozygosity -- the former would be driven
mostly by the log R ratios.  This is experimental and subject to
change.
}
\details{
The \code{hmm2} method allows parallelization across samples using
the foreach paradigm.  Parallelization is automatic when enabled
via packages such as snow/doSNOW.
}
\examples{
tp <- TransitionParam()
TransitionParam(taup=1e12)
data(snp_exp)
emission_param <- EmissionParam(temper=1/2)
fit <- hmm2(snp_exp, emission_param)
unlist(fit)
cnvSegs(fit)
## There is too little data to infer cnv reliably in this trivial example.
## To illustrate filtering options on the results, we select
## CNVs for which
## - the CNV call has a posterior probability of at least 0.5
## - the number of features is 2 or more
## - the HMM states are 1 (homozygous deletion) or 2 (hemizygous deletion)
fp <- FilterParam(probability=0.5, numberFeatures=2, state=c("1", "2"))
cnvSegs(fit, fp)
## for parallelization
\dontrun{
   library(snow)
   library(doSNOW)
   cl <- makeCluster(2, type = "SOCK")
   registerDoSNOW(cl)
   fit <- hmm2(snp_exp, emission_param)
}
}
