% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/methods-FilterParam.R
\docType{class}
\name{FilterParam-class}
\alias{FilterParam-class}
\alias{FilterParam}
\alias{probability,FilterParam-method}
\alias{state,FilterParam-method}
\alias{show,FilterParam-method}
\title{Container for the common criteria used to  filtering genomic ranges}
\usage{
FilterParam(
  probability = 0.99,
  numberFeatures = 10,
  seqnames = paste0("chr", c(1:22, "X", "Y")),
  state = as.character(1:6),
  width = 1L
)

\S4method{probability}{FilterParam}(object)

\S4method{state}{FilterParam}(object)

\S4method{show}{FilterParam}(object)
}
\arguments{
\item{probability}{minumum probability for the call}

\item{numberFeatures}{minumum number of SNPs/nonpolymorphic features in a region}

\item{seqnames}{the seqnames (character string or \code{Rle} to keep)}

\item{state}{character:  the HMM states to keep}

\item{width}{the minimum widht of a region}

\item{object}{a \code{FilterParam} object}
}
\description{
The maximum a posteriori estimate of the trio copy number state for
each genomic range is represented in a
\code{\link{GRanges}}-derived class.  Ultimately, these ranges will
be filtered based on the trio copy number state (e.g., denovo
deletions), size, number of features (SNPs), or chromosome.
\code{FilterParam} is a container for the parameters commmonly used
to filter the genomic ranges.
}
\section{Slots}{

\describe{
\item{\code{probability}}{a length-one numeric vector indicating the
minimum posterior probability for the called state. Genomic
intervals with posterior probabilities below \code{probability}
will be filtered.}

\item{\code{numberFeatures}}{a positive integer indicating the minimum
number of features in a segment}

\item{\code{seqnames}}{a character vector of \code{seqnames} to select
(i.e., 'chr1' for only those intervals on chromosome 1)}

\item{\code{width}}{positive integer indicating the minimal width of
genomic intervals}

\item{\code{state}}{character string indicating which hidden Markov model states to select}
}}

\examples{
fp <- FilterParam()
width(fp)
numberFeatures(fp)
seqnames(fp)
## To select CNV segments for which
## - the CNV call has a 'posterior' probability of at least 0.95
## - the number of features is at least 10
## - the HMM states are 1 (homozygous deletion) or 2 (hemizygous deletion)
FilterParam(probability=0.95, numberFeatures=10, state=c("1", "2"))

}
\seealso{
\code{\link{cnvFilter}} \code{\link{cnvSegs}} \code{\link{hmm2}}
}
