% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.R
\name{readVDJcontigs}
\alias{readVDJcontigs}
\alias{readVDJcontigs,character-method}
\title{Load 10X CellRanger V(D)J data}
\usage{
readVDJcontigs(samples, ...)

\S4method{readVDJcontigs}{character}(samples, sample.names = names(samples))
}
\arguments{
\item{samples}{A character vector containing one or more directory names,
each corresponding to a 10X sample. Each directory should contain a file
named \code{filtered_contig_annotations.csv}.}

\item{...}{additional arguments.}

\item{sample.names}{A character vector of length equal to \code{samples}
containing the sample names to store in the output object. If \code{NULL},
the \code{basename}s of each directory will be used.}
}
\value{
A \code{SplitDataFrameList} object containing data on all contigs,
grouped by cell barcode.
}
\description{
Creates a \code{SplitDataFrameList} (see
\code{\link[IRanges]{DataFrameList}}) from a character vector of directory
names corresponding to the output of the CellRanger V(D)J pipeline.
}
\details{
The resulting list of \code{DataFrame}s contains all the data in
\code{filtered_contig_annotations.csv}, split by cell barcode. Note that
the index of each sample in \code{samples} is concatenated to the cell
barcodes, so that cells from different samples cannot have identical
barcodes.
}
\examples{
# write the example data to a temporary directory
example(writeVDJcontigs)
# specify sample locations and read in data
samples <- file.path(loc, c('sample1','sample2'))
contigs <- readVDJcontigs(samples)

}
