% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Show_database_information.R
\name{show_contained_variants_for_ccl}
\alias{show_contained_variants_for_ccl}
\title{Variants In Cancer Cell Line}
\usage{
show_contained_variants_for_ccl(
    name_ccl, 
    ref_gen,
    library_name,
    mutational_weight_inclusion_threshold
)
}
\arguments{
\item{name_ccl}{a character vector giving the identifier 
of the cancer cell line for which mutations will be shown.}

\item{ref_gen}{a character vector specifying the reference 
genome version. All training sets are associated with a 
reference genome version. Default is \code{"GRCH37"}.}

\item{library_name}{Name of the reference library}

\item{mutational_weight_inclusion_threshold}{Include only mutations 
with a weight of at least x. Range: 0.0 to 1.0. 1= unique to CL. 
~0 = found in many CCL samples.}
}
\value{
GenomicRanges object that contains the ccl's variants
}
\description{
This function shows all mutations present in the database 
for a selected cancer cell line and reference genome.
}
\examples{
## Show all mutations for Cancer Cell Line 'SK_OV_3'
show_contained_variants_for_ccl(
    name_ccl = "SK_OV_3",
    ref_gen = "GRCH37",
    library_name = "CELLMINER",
    mutational_weight_inclusion_threshold = 0
)
}
