% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Show_database_information.R
\name{show_contained_ccls}
\alias{show_contained_ccls}
\title{show_contained_ccls}
\usage{
show_contained_ccls(ref_gen, verbose)
}
\arguments{
\item{ref_gen}{a character vector specifying the reference genome version.
All training sets are associated with a reference genome version.
Default is \code{"GRCH37"}.}

\item{verbose}{Should DB informations be printed?}
}
\value{
R table which contains identifiers of all cancer cell line samples
 which match the specified parameters (reference genome and library).
}
\description{
This function displays the names, amount of mutations and the overall 
weight of the mutations of all contained cancer cell line fingerprints 
for a chosen reference genome and optional library.
}
\examples{
## Show all contained cancer cell lines for reference GRCH37:
show_contained_ccls(ref_gen = "GRCH37", verbose = TRUE)
}
