% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitSegBIC.R
\name{fitSegBIC}
\alias{fitSegBIC}
\title{Fit segmented regression models on a feature/gene}
\usage{
fitSegBIC(Data, maxK = 2, tVectIn = NULL, minNumInSeg = 5,
  pvalCut = 0.1, numTry = 5, keepFit = FALSE)
}
\arguments{
\item{Data}{a matrix of normalized expression measurements. Rows are 
genes/features and columns are samples.}

\item{maxK}{maximum number of breakpoints to consider. For each gene,
trendy will fit maxK + 1 models containing 0 -> maxK breakpoints
(1 -> (maxK + 1) segments). The model with the lowest BIC 
value will be selected (unless forceRsq = TRUE, see below).}

\item{tVectIn}{a numerical vector indicating the time-points or the 
order of samples. If it is NULL (default), then the time/order 
will be assumed to be equaly spaced from 1:N (N is number of samples).}

\item{minNumInSeg}{minimum number of samples required to be within 
a segment. If a breakpoint model has a segment with fewer than 
minNumInSeg point in any segment, then the model is not 
considered valid.}

\item{pvalCut}{p-value cutoff. If the p-value of a segment is greater than
PvalCut, then the segment will be called as 'no change'.}

\item{numTry}{the number of different seeds to try. If all numTry runs 
fail, then the linear regression (no breakpoints, one segment) model 
will be returned.}

\item{keepFit}{whether to report the fitted object (default is FALSE).}
}
\value{
Trend: direction of each sample; -1: down, 0: no change, 1: up
 Slope: fitted slopes, Slope.Trend: sign of fitted slopes, 
 Slope.Pvalue: p value of each segment, Breakpoint: estimated breakpoints,
 Fitted.Values: fitted values AdjustedR2: adjusted r value of the model
 Fit: fit object
}
\description{
fits segmented regression models
}
\author{
Rhonda Bacher and Ning Leng
}
