% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecate_Fun.R, R/tree_convertNode.R
\name{transNode}
\alias{transNode}
\alias{convertNode}
\title{Transfer between node number and node label}
\usage{
transNode(tree, node, use.alias = FALSE, message = FALSE)

convertNode(tree, node, use.alias = FALSE, message = FALSE)
}
\arguments{
\item{tree}{A phylo object}

\item{node}{A character or numeric vector representing tree node label(s) or
tree node number(s)}

\item{use.alias}{A logical value, TRUE or FALSE. This is an optional argument
that only requried when the input \code{node} is a numeric vector. The
default is FALSE, and the node label would be returned; otherwise, the
alias of node label would be output. The alias of node label is created by
adding a prefix \code{"alias_"} to the node number.}

\item{message}{A logical value, TRUE or FALSE. The default is FALSE. If TRUE,
message will show when a tree have duplicated labels for some internal
nodes.}
}
\value{
a vector
}
\description{
\code{convertNode} does the transformation between the number and the label of
a node on a tree
}
\examples{
library(ggtree)

data(tinyTree)

ggtree(tinyTree, branch.length = 'none') +
geom_text2(aes(label = label), hjust = -0.3) +
geom_text2(aes(label = node), vjust = -0.8,
hjust = -0.3, color = 'blue')

#check whether the node number and node label are matched
convertNode(tinyTree, node = c(11, 2, 4, 15))

convertNode(tree = tinyTree, node = c("Node_16", "Node_11"))
convertNode(tree = tinyTree, node = c("alias_16", "alias_11"))
}
\author{
Ruizhu Huang
}
