% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrajectoryGeometry.R
\name{projectPathToSphere}
\alias{projectPathToSphere}
\title{Project a path onto the unit sphere}
\usage{
projectPathToSphere(path, from = 1, to = nrow(path), d = ncol(path))
}
\arguments{
\item{path}{- This is an mxn dimensional matrix. Each row is
considered a point.}

\item{from}{- The starting place along the path which will be
treated as the center of the sphere.  This defaults to 1.}

\item{to}{- The end point of the path.  This defaults to
nrow(path).}

\item{d}{- The dimension under consideration.  This defaults to
ncol(path)}
}
\value{
This returns a projection of the path onto the d-1 sphere
    in the form of a (to - from) x d matrix.
}
\description{
This function takes a path in d dimensional space and projects it onto
the d-1 sphere.  It takes as additional arguments the starting and ending
points under consideration and the dimension to be considered.
}
\examples{
projection1 = projectPathToSphere(straight_path)
projection2 = projectPathToSphere(crooked_path,from=6)
}
