% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TileDBRealizationSink.R
\name{TileDBRealizationSink}
\alias{TileDBRealizationSink}
\alias{writeTileDBArray}
\alias{TileDBRealizationSink-class}
\alias{write_block,TileDBRealizationSink-method}
\alias{type,TileDBRealizationSink-method}
\alias{coerce,TileDBRealizationSink,TileDBMatrix-method}
\alias{coerce,TileDBRealizationSink,TileDBArray-method}
\alias{coerce,TileDBRealizationSink,DelayedArray-method}
\alias{coerce,ANY,TileDBArray-method}
\alias{coerce,ANY,TileDBMatrix-method}
\alias{coerce,ANY,TileDBRealizationSink-method}
\title{Write arrays to TileDB}
\description{
Write array data to a TileDB backend via \pkg{DelayedArray}'s \linkS4class{RealizationSink} machinery.
}
\section{Writing a TileDBArray}{

\preformatted{TileDBRealizationSink(
    dim, 
    dimnames=NULL, 
    type="double", 
    path=getTileDBPath(), 
    attr=getTileDBAttr(), 
    storagetype=NULL,
    dimtype=getTileDBDimType(),
    sparse=FALSE,
    extent=getTileDBExtent(), 
    offset=1L,
    cellorder=getTileDBCellOrder(),
    tileorder=getTileDBTileOrder(),
    capacity=getTileDBCapacity(),
    context=getTileDBContext()
)}
returns a TileDBRealizationSink object that can be used to write content to a TileDB backend.
It accepts the following arguments:
\itemize{
\item \code{dim}, an integer vector (usually of length 2) to specify the array dimensions.
\item \code{dimnames}, a list of length equal to \code{dim}, containing character vectors with names for each dimension.
Defaults to \code{NULL}, i.e., no dimnames.
\item \code{type}, a string specifying the R data type for the newly written array.
Currently only \code{"double"}, \code{"integer"} and \code{"logical"} arrays are supported.
\item \code{path}, a string containing the location of the new TileDB backend.
\item \code{attr}, a string specifying the name of the attribute to store.
\item \code{storagetype}, a string specifying the TileDB data type for the attribute, e.g., \code{"UINT8"}, \code{"FLOAT32"}.
If \code{NULL}, this is automatically determined from \code{type} using \code{\link{r_to_tiledb_type}}.
\item \code{dimtype}, a string specifying the TileDB data type for the dimension.
\item \code{sparse}, a logical scalar indicating whether the array should be stored in sparse form.
\item \code{extent}, an integer scalar (or vector of length equal to \code{dim}) specifying the tile extent for each dimension.
Larger values improve compression at the cost of unnecessary data extraction during reads. 
\item \code{offset}, an integer scalar (or vector of length equal to \code{dim}) specifying the starting offset for each dimension's domain.
\item \code{cellorder}, a string specifying the ordering of cells within each tile.
\item \code{tileorder}, a string specifying the ordering of tiles across the array.
\item \code{capacity}, an integer scalar specifying the size of each data tile in the sparse case.
\item \code{context} is the TileDB context, defaulting to the output of \code{\link{tiledb_ctx}()}.
}

\code{writeTileDBArray(x, sparse=is_sparse(x), ...)} writes the matrix-like object \code{x} to a TileDB backend,
returning a \linkS4class{TileDBArray} object referring to that backend. 
Appropriate values for \code{dim}, \code{dimnames} and \code{type} are determined automatically from \code{x} itself.
All other arguments described for \code{TileDBRealizationSink} can be passed into \code{...} to configure the representation.
}

\section{Coercing to a TileDBArray}{

\code{as(x, "TileDBArray")} will coerce a matrix-like object \code{x} to a TileDBArray object.

\code{as(x, "TileDBArraySeed")} will coerce a matrix-like object \code{x} to a TileDBArraySeed object.

\code{as(x, "TileDBMatrix")} will coerce a matrix-like object \code{x} to a TileDBArraySeed object.

\code{as(x, "TileDBArray")} will coerce a TileDBRealizationSink \code{x} to a TileDBArray object.

\code{as(x, "TileDBArraySeed")} will coerce a TileDBRealizationSink \code{x} to a TileDBArraySeed object.

\code{as(x, "DelayedArray")} will coerce a TileDBRealizationSink \code{x} to a TileDBArray object.
}

\section{Sink internals}{

\code{write_block(sink, viewport, block)} will write the subarray \code{block} to the TileDBRealizationSink \code{sink}
at the specified \code{viewport}, returning \code{sink} upon completion.
See \code{\link{write_block}} in \pkg{DelayedArray} for more details.

\code{type(x)} will return a string specifying the type of the TileDBRealizationSink \code{x}.
}

\examples{
X <- matrix(rnorm(100000), ncol=200)
path <- tempfile()
out <- writeTileDBArray(X, path=path)

# Works for integer matrices.
Xi <- matrix(rpois(100000, 2), ncol=200)
pathi <- tempfile()
outi <- writeTileDBArray(Xi, path=pathi)

# Works for logical matrices.
Xl <- matrix(rpois(100000, 0.5) > 0, ncol=200)
pathl <- tempfile()
outl <- writeTileDBArray(Xl, path=pathl)

# Works for sparse numeric matrices.
Y <- Matrix::rsparsematrix(1000, 1000, density=0.01)
path2 <- tempfile()
out2 <- writeTileDBArray(Y, path=path2)

# And for sparse logical matrices.
path2l <- tempfile()
out2l <- writeTileDBArray(Y > 0, path=path2l)

# Works for dimnames.
rownames(X) <- sprintf("GENE_\%i", seq_len(nrow(X)))
path3 <- tempfile()
out3 <- writeTileDBArray(X, path=path3)

}
