% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perform_analysis.R
\name{getPEC504Temperature}
\alias{getPEC504Temperature}
\title{Get pEC50 for a protein of interest at a specific temperatures
(optimally the melting point of the protein)}
\usage{
getPEC504Temperature(fstat_df, protein, temperaturePEC50 = 60)
}
\arguments{
\item{fstat_df}{data frame as obtained after calling 
\code{getModelParamsDf}, containing fitted null and 
alternative model parameters for each protein}

\item{protein}{character string referring to the protein 
of interest}

\item{temperaturePEC50}{temperature (numeric) at which pEC50
should be inferred}
}
\value{
numeric value specifying the pEC50 for the 
indicated protein and temperature
}
\description{
Get pEC50 for a protein of interest at a specific temperatures
(optimally the melting point of the protein)
}
\examples{
data("simulated_cell_extract_df")

model_params_df <- getModelParamsDf(
   df = filter(simulated_cell_extract_df, 
           clustername == "tp1"))

getPEC504Temperature(
    fstat_df = model_params_df, 
    protein = "tp1", 
    temperaturePEC50 = 60)
}
