% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TOP_survival.R
\name{TOP_survival}
\alias{TOP_survival}
\title{TOP_survival}
\usage{
TOP_survival(
  x_list,
  y_list,
  nFeatures = 50,
  dataset_weights = NULL,
  sample_weights = FALSE,
  nCores = 1
)
}
\arguments{
\item{x_list}{A list of data frames, each containing the data for a single
batch or dataset. Columns are features and rows are observations.}

\item{y_list}{A list of data frames, where the first columns in each data
frame is the time and the second column is the event status. The length of
this list should be the same as the length of x_list.}

\item{nFeatures}{Number of features to return, Default: 50}

\item{dataset_weights}{a list of data frames that refer to any grouping
structure in the batches, Default: NULL}

\item{sample_weights}{Should each batch we weighted equally? This is
important in unequal sample sizes, Default: FALSE}

\item{nCores}{A numeric specifying the number of cores used if the user
wants to use parallelisation, Default: 1}
}
\value{
A cox net model
}
\description{
FUNCTION_DESCRIPTION
}
\details{
DETAILS
}
\examples{
data(TOP_data_binary, package = "TOP")
time <- rpois(300, c(600, 1000))
surv <- sample(c(0, 1), 300, replace = TRUE)
y <- data.frame(time, surv)

batch <- rep(paste0("y", 1:3), c(100, 100, 100))
y_list <- y |> split(batch)

x_list <- list(TOP_data_binary$x1, TOP_data_binary$x2, TOP_data_binary$x3)

TOP_survival(x_list[-3], y_list[-3], nFeatures = 10)
}
