% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TOP_model.R
\name{TOP_model}
\alias{TOP_model}
\title{TOP_model}
\usage{
TOP_model(
  x_list,
  y_list,
  covariates = NULL,
  dataset_weights = NULL,
  sample_weights = FALSE,
  optimiseExponent = FALSE,
  nCores = 1
)
}
\arguments{
\item{x_list}{a list of data frames, each containing the data for a single
batch or dataset. Columns should be features and rows should be
observations.}

\item{y_list}{a list of factors, each containing the labels for a single
batch or dataset. The length of this list should be the same as the length
of x_list.}

\item{covariates}{a list of data frames with the covariates that should be
included in the model, Default: NULL}

\item{dataset_weights}{a list of data frames that refer to any grouping
structure in the batches, Default: NULL}

\item{sample_weights}{Should each batch we weighted equally? This is
important in unequal sample sizes, Default: FALSE}

\item{optimiseExponent}{Should the exponent used to modufy the lasso weights
be optimised using resubstitution?, Default: FALSE}

\item{nCores}{A numeric specifying the number of cores used if the user
wants to use parallelisation, Default: 1}
}
\value{
Returns a list with the following elements: models, which is a
glmnet object and features, which is a list of the features used in each
model.
}
\description{
The main function of the TOP package. This function returns a
glmnet model .
}
\examples{
data(TOP_data_binary, package = "TOP")

x1 <- TOP_data_binary$x1
x2 <- TOP_data_binary$x2
x3 <- TOP_data_binary$x3
y1 <- TOP_data_binary$y1
y2 <- TOP_data_binary$y2
y3 <- TOP_data_binary$y3

set.seed(23)
x_list <- list(x1, x2)
y_list <- list(factor(y1), factor(y2))

model <- TOP_model(x_list, y_list)

}
