% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importFIMO.R
\name{importFIMO,TabixFile,GRanges-method}
\alias{importFIMO,TabixFile,GRanges-method}
\alias{importFIMO}
\alias{importFIMO,character,missing-method}
\title{import a FIMO bed-like file}
\usage{
\S4method{importFIMO}{TabixFile,GRanges}(src, parms, ...)

\S4method{importFIMO}{character,missing}(src, parms, ...)
}
\arguments{
\item{src}{TabixFile instance}

\item{parms}{a GRanges instance delimiting the import; multiple GRanges can be used}

\item{\dots}{passed to GenomicRanges::GRanges}
}
\value{
instance of GRanges
}
\description{
import a FIMO bed-like file
}
\examples{
if (requireNamespace("Rsamtools")) {
 tf = Rsamtools::TabixFile(system.file("M5946_1/chr1.bed.gz", package="TFutils"))
 importFIMO(tf, GenomicRanges::GRanges("chr1", IRanges::IRanges(1e6,11e6)))
 }
}
