% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableFeatures.R
\name{tableFeatures}
\alias{tableFeatures}
\title{Title
Show selected features as Table}
\usage{
tableFeatures(Z, index)
}
\arguments{
\item{Z}{Tensor of features}

\item{index}{List that includes selected features and P-values}
}
\value{
Table list of selected features
}
\description{
Title
Show selected features as Table
}
\examples{
set.seed(2)
require(rTensor)
HOSVD <- hosvd(as.tensor(array(runif(10000*3*3),c(10000,3,3))),c(10,3,3))
input_all <- c(2,2)
index <- selectFeature(HOSVD,input_all,de=0.01,p0=0.01)
index$index[seq_len(100)] <- TRUE
Z <- PrepareSummarizedExperimentTensor(
sample=matrix(as.character(seq_len(9)),c(3,3)),
        feature=as.character(seq_len(10000)),
        value=array(runif(10000*3*3),c(10,3,3)))
head(tableFeatures(Z,index))
}
