% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBanalysis.R
\name{DBanalysis}
\alias{DBanalysis}
\title{Perform differential expression analysis}
\usage{
DBanalysis(
  object,
  categories = "timepoint",
  norm.lib = TRUE,
  filter.type = NULL,
  filter.value = NULL,
  samplePassfilter = 2,
  ...
)
}
\arguments{
\item{object}{a \code{TCA} object.}

\item{categories}{character string giving which column in \code{design} 
will be used for differential analysis. For time course analysis, the default
column is "\code{timepoint}".}

\item{norm.lib}{logical indicating whether or not use effective
library size when perform normalization. See \code{\link{counts}} for more 
details.}

\item{filter.type}{character string indicating which type of count
(raw or normalized) is used when performing filtering. Options are
"\code{raw}", "\code{cpm}", "\code{rpkm}", "\code{NULL}". No filtering will 
be performed when using "\code{NULL}'.}

\item{filter.value}{a numberic value; minimum values of selected
\code{filter.type} ("\code{raw}", "\code{cpm}", "\code{rpkm}"). It is used in 
combination with \code{samplePassfilter}.}

\item{samplePassfilter}{a numberic value indicating the minimum number
of samples/libraries in which a genomic feature has counts value 
(raw or normalized) more than \code{filter.value}. Smaller than this number, 
the genomic feature will be filtered out.}

\item{...}{additional arguments passed to \code{\link{glmFit}} from
\code{edgeR} package.}
}
\value{
A \code{TCA} object
}
\description{
This function is a wrapper for the \code{\link{glmFit}} in edgeR package.
}
\details{
The differetial event is detected by using the generalized
linear model (GLM) methods (McCarthy et al, 2012). This function
fits the read counts of each genes to a negative binomial glm by
using \code{\link{glmFit}} function from edgeR. To further test the
significance of changes, see \code{DBresult}, \code{TopDBresult}
}
\examples{
data(tca_ATAC)
tca_ATAC <- DBanalysis(tca_ATAC)

}
\references{
McCarthy,D.J.,Chen, Y., & Smyth, G. K.(2012). Differential
expression analysis of multifactor RNA-Seq experiments with respect to
biological variation. Nucleic acids research 40, 4288-4297.
}
\seealso{
\code{DBresult}, \code{TopDBresult}
}
\author{
Mengjun Wu, Lei Gu
}
