% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/primer3_io.R
\name{parsePrimer3Output}
\alias{parsePrimer3Output}
\title{Parse Primer3 Output}
\usage{
parsePrimer3Output(object, primer3_output)
}
\arguments{
\item{object}{The \code{\link[TAPseq:TsIO-class]{TsIO}} or
\code{\link[TAPseq:TsIOList-class]{TsIOList}} object used to design primers. No errors or
warnings if this is a different \code{TsIO} or \code{TsIOList} object!}

\item{primer3_output}{Character vector containing raw Primer3 output.}
}
\value{
\code{\link[TAPseq:TsIO-class]{TsIO}} or \code{\link[TAPseq:TsIOList-class]{TsIOList}}
  object with added Primer3 output
}
\description{
Parse Primer3 output and add to input \code{\link[TAPseq:TsIO-class]{TsIO}} or
\code{\link[TAPseq:TsIOList-class]{TsIOList}} object. This function is usually not used by the
user, as \code{\link[TAPseq]{designPrimers}} handles Primer3 output parsing.
}
\examples{
\dontrun{
# chromosome 11 truncated transcript sequences
data("chr11_truncated_txs_seq")

# create TsIOList object for the first two sequence templates
tapseq_io <- TAPseqInput(chr11_truncated_txs_seq[1:2], product_size_range = c(350, 500))

# create boulder IO records
io_record <- createIORecord(tapseq_io)

# design primers and store raw Primer3 output
primer3_core <- getOption("TAPseq.primer3_core")
primer3_output <- system2(command = primer3_core, input = io_record, stdout = TRUE)

# parse output and add it to input TsIO object(s)
tapseq_io <- parsePrimer3Output(tapseq_io, primer3_output)
tapseq_primers(tapseq_io)
}
}
\keyword{internal}
