% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_primers.R
\name{checkPrimers}
\alias{checkPrimers}
\alias{checkPrimers,TsIO-method}
\alias{checkPrimers,TsIOList-method}
\title{Check primers for complementarity}
\usage{
checkPrimers(
  object,
  primer_opt_tm = 63,
  primer_min_tm = 59,
  primer_max_tm = 66,
  thermo_params_path = NA,
  primer3_core = getOption("TAPseq.primer3_core")
)

\S4method{checkPrimers}{TsIO}(
  object,
  primer_opt_tm = 63,
  primer_min_tm = 59,
  primer_max_tm = 66,
  thermo_params_path = NA,
  primer3_core = getOption("TAPseq.primer3_core")
)

\S4method{checkPrimers}{TsIOList}(
  object,
  primer_opt_tm = 63,
  primer_min_tm = 59,
  primer_max_tm = 66,
  thermo_params_path = NA,
  primer3_core = getOption("TAPseq.primer3_core")
)
}
\arguments{
\item{object}{A \code{\link[TAPseq:TsIO-class]{TsIO}} or
\code{\link[TAPseq:TsIOList-class]{TsIOList}} object containing designed primers.}

\item{primer_opt_tm, primer_min_tm, primer_max_tm}{Optimal, minumum and maximum primer melting
temperature. Should be the same values that were used when designing the primers.}

\item{thermo_params_path}{Optional path (character) to the \code{primer3_config} directory. Only
required when using Primer3 < 2.5.0.}

\item{primer3_core}{Path (character) to the \code{primer3_core} executable. Usually this is
inferred when loading/attaching the package.}
}
\value{
A \code{\link[base]{data.frame}} with \code{check_primers} results.
}
\description{
Check a TAP-seq primer set, i.e. outer or inner primers for a target gene panel, for potential
complementarity issues when multiplexing. Uses Primer3's \code{check_primers} functionality.
}
\section{Methods (by class)}{
\itemize{
\item \code{checkPrimers(TsIO)}: Check primers from \code{TsIO} objects.

\item \code{checkPrimers(TsIOList)}: Check primers from \code{TsIOList} objects.

}}
\examples{
library(ggplot2)

# chr11 primers example data
data("chr11_primers")

# pick best primers based on predicted off-targets for subset of all primers
best_primers <- pickPrimers(chr11_primers, n = 1, by = "off_targets")

# check for complementarity
\dontrun{
comp <- checkPrimers(best_primers)

# plot complementarity scores for every pair. the lines indicate complementarity scores of 47,
# the default value applied by Primer3 to identify high complementarity primer pairs
ggplot(comp, aes(x = primer_pair_compl_any_th, y = primer_pair_compl_end_th)) +
  geom_hline(aes(yintercept = 47), colour = "darkgray", linetype = "dashed") +
  geom_vline(aes(xintercept = 47), colour = "darkgray", linetype = "dashed") +
  geom_point(alpha = 0.25) +
  theme_bw()
}
}
\seealso{
\url{http://primer3.org/manual.html} for Primer3 manual.
}
