% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance_analysis.R
\name{dinu_dist}
\alias{dinu_dist}
\alias{dinu_dist,ANY-method}
\title{Calculating the dinucleotide usage difference between sequences}
\usage{
dinu_dist(seq, ref)

\S4method{dinu_dist}{ANY}(seq, ref)
}
\arguments{
\item{seq}{the input DNA sequnece of \code{DNAStringSet} or
\code{regioned_dna} class.}

\item{ref}{the reference DNA sequnece of \code{DNAStringSet} or
\code{regioned_dna} class.}
}
\value{
vector
}
\description{
We use a least squares approach to estimate the dinucleotide usage
difference between DNA sequences
}
\details{
similar method that applied in "Daniel Macedo de Melo Jorge, Ryan E.
  Mills, Adam S. Lauring, CodonShuffle: a tool for generating and analyzing
  synonymously mutated sequences, Virus Evolution, Volume 1, Issue 1, March
  2015, vev012, https://doi.org/10.1093/ve/vev012"
}
\examples{
filepath <- system.file("extdata", "example.fasta", package = "SynMut")
rgd.seq <- input_seq(filepath)
get_cu(rgd.seq)

mut.seq <- codon_random(rgd.seq)
dinu_dist(mut.seq, rgd.seq)
}
