% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codon_to.R
\name{codon_to}
\alias{codon_to}
\alias{codon_to,regioned_dna-method}
\title{Maximize or minimize the usage of certain codon.}
\usage{
codon_to(object, max.codon = NA, min.codon = NA, ...)

\S4method{codon_to}{regioned_dna}(object, max.codon, min.codon)
}
\arguments{
\item{object}{A regioned_dna object.}

\item{max.codon}{A string of a codon.}

\item{min.codon}{A string of a codon.}

\item{...}{...}
}
\value{
A regioned_dna object.
}
\description{
Input string of a codon to either the "max.codon = " or "min.codon = "
parameter to maximize or minimize the usage of certain codon in the sequence.
}
\details{
The ideas for this function is simple. We first extract the mutable
  regions for every sequences, then mutated the synonymous codons of the
  input to the desired. There will be only one ideal design for the
  maximization problem, however there may be numerous comparable designs
  having the same minimal usage of certain codon, as we randomly sample
  synonymous codon for substitution when solving the minimization problem.
}
\examples{
filepath <- system.file("extdata", "example.fasta", package = "SynMut")
rgd.seq <- input_seq(filepath)
get_cu(codon_to(rgd.seq, max.codon = "AAC")) - get_cu(rgd.seq)
get_cu(codon_to(rgd.seq, min.codon = "AAC")) - get_cu(rgd.seq)

}
\seealso{
\code{\link{input_seq}}, \code{\link{dinu_to}},
  \code{\link{codon_random}}, \code{\link{codon_mimic}}
}
