% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replacePrediction.R
\name{replacePrediction}
\alias{replacePrediction}
\title{Replace compartment predictions to neighborhood predictions}
\usage{
replacePrediction(df, column = c("svm.pred.all", "Observation", "svm.pred"))
}
\arguments{
\item{df}{data.frame; all predictions at the compartment level and
probablity vectors for each protein}

\item{column}{character; selected column in the data frame, df}
}
\value{
replaced.df
}
\description{
Compartment level classifications are replaced with
neighborhood level assignment. It is a helper function.
}
\examples{
{

#define mock data frame
df <- data.frame(svm.pred.all = c("S1","S2","S3","S4",
"N1","N2","N3","N4",
"C1","C2","C3","C4","C5",
"M1","M2"))

df$svm.pred.all <- as.character(df$svm.pred.all)
df$Prob <- "1"

df <- replacePrediction(df, column = "svm.pred.all")
}
}
