% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probabilityThresholdCompartments.R
\name{computeThresholdCompartment}
\alias{computeThresholdCompartment}
\title{Probability threshold for compartment classification}
\usage{
computeThresholdCompartment(test.repA, test.repB)
}
\arguments{
\item{test.repA}{data.frame; test predictions, observation and
probablity vectors for each protein in replicate A}

\item{test.repB}{data.frame; test predictions, observation and
probablity vectors for each protein in replicate B}
}
\value{
threshold.compartment.df
}
\description{
Thresholds for each compartment are decided to get
confident predictions.
}
\examples{
{

df <- loadData(SubCellBarCode::hcc827Ctrl)

c.prots <- calculateCoveredProtein(rownames(df), markerProteins[,1])

set.seed(7)
c.prots <- sample(c.prots, 550)
cls <- svmClassification(c.prots, df, markerProteins)

test.A <- cls[[1]]$svm.test.prob.out
test.B <- cls[[2]]$svm.test.prob.out

t.c.df <- computeThresholdCompartment(test.A, test.B)
}
}
