% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputeEmbedding.R
\name{imputeEmbedding}
\alias{imputeEmbedding}
\title{Impute values using StabMap joint embedding}
\usage{
imputeEmbedding(
  assay_list,
  embedding,
  reference = Reduce(union, lapply(assay_list, colnames)),
  query = Reduce(union, lapply(assay_list, colnames)),
  neighbours = 5,
  fun = mean
)
}
\arguments{
\item{assay_list}{List of mosaic data from which to perform imputation.}

\item{embedding}{Joint embedding from which to extract nearest neighbour
relationships.}

\item{reference}{Character vector of cell names to treat as reference cells.}

\item{query}{Character vector of cell names to treat as query cells.}

\item{neighbours}{Number of nearest neighbours to consider (default 5).}

\item{fun}{function (default `mean`) to aggregate nearest neighbours'
imputed values.}
}
\value{
List containing imputed values from each assay_list
data matrix which contains reference cells.
}
\description{
Performs naive imputation of values from the list of mosaic data
and joint embedding from StabMap.
}
\examples{
set.seed(2021)
assay_list <- mockMosaicData()
lapply(assay_list, dim)

# stabMap
out <- stabMap(assay_list,
  ncomponentsReference = 20,
  ncomponentsSubset = 20
)

# impute values
imp <- imputeEmbedding(assay_list, out)

# inspect the imputed values
lapply(imp, dim)
imp[[1]][1:5, 1:5]

}
