% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotQCmetrics.R
\name{plotQCmetrics}
\alias{plotQCmetrics}
\title{Plot QC metrics for a Single Sample in a SpatialExperiment object}
\usage{
plotQCmetrics(
  spe,
  sample_id = "sample_id",
  sample = unique(spe$sample_id)[1],
  metric = "detected",
  outliers = NULL,
  point_size = 2,
  colors = c("white", "black"),
  stroke = 1
)
}
\arguments{
\item{spe}{A SpatialExperiment object containing the data to be plotted.}

\item{sample_id}{A character string specifying the column name in
\code{colData(spe)} that contains unique sample identifiers.
Default is "sample_id".}

\item{sample}{A character string or numeric value specifying the sample to be
plotted. By default, it plots the first unique sample found in
\code{spe$sample_id}.}

\item{metric}{A character string specifying the metric to be visualized
in the plot. This metric should be a column name in \code{colData(spe)}.}

\item{outliers}{A character string specifying the column name in
\code{colData(spe)} that indicates whether a data point is considered an
outlier. Default is NULL.}

\item{point_size}{A numeric value specifying the size of the points in the
plot. Default is 2.}

\item{colors}{A character vector specifying the colors to be used for the
gradient scale. If length is 2, the gradient will be a single color
gradient.}

\item{stroke}{A numeric value specifying the border thickness for outlier
points. Default is 1.}
}
\value{
The function returns a plot object created by \code{make_escheR} and
modified with additional layers for visualizing the specified metric and
outliers. The plot is not explicitly printed by the function and should be
printed by the caller.
}
\description{
This function generates a plot for a specified sample within a
SpatialExperiment object, highlighting outliers based on a specified
metric. The plot visualizes the metric of interest and indicates outliers
with a distinct color.
}
\examples{
library(SpotSweeper)
library(SpatialExperiment)
library(escheR)

# load example data
spe <- STexampleData::Visium_humanDLPFC()

# change from gene id to gene names
rownames(spe) <- rowData(spe)$gene_name

# drop out-of-tissue spots
spe <- spe[, spe$in_tissue == 1]
spe <- spe[, !is.na(spe$ground_truth)]

# Identifying the mitochondrial transcripts in our SpatialExperiment.
is.mito <- rownames(spe)[grepl("^MT-", rownames(spe))]

# Calculating QC metrics for each spot using scuttle
spe <- scuttle::addPerCellQCMetrics(spe, subsets = list(Mito = is.mito))
colnames(colData(spe))

# Identifying local outliers using SpotSweeper
spe <- localOutliers(spe,
                     metric = "sum",
                     direction = "lower",
                     log = TRUE
)

plotQCmetrics(spe, metric="sum", outliers="sum_outliers")

}
