% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flagVisiumOutliers.R
\name{flagVisiumOutliers}
\alias{flagVisiumOutliers}
\title{Flag Visium Outliers in SpatialExperiment Objects}
\usage{
flagVisiumOutliers(spe)
}
\arguments{
\item{spe}{A \code{SpatialExperiment} object containing spatial transcriptomics data.
The object must include \code{array_row} and \code{array_col} columns in its \code{colData} that
specify the spatial coordinates of each spot.}
}
\value{
A \code{SpatialExperiment} object identical to the input \code{spe} but with an additional
logical column \code{systematic_outliers} in its \code{colData}. This column indicates whether
each spot is flagged as a technical outlier (\code{TRUE}) or not (\code{FALSE}).
}
\description{
The \code{flagVisiumoutliers} function identifies and flags Visium systematic outlier spots in a
\code{SpatialExperiment} object based on barcodes. These outliers are marked in the \code{colData}
of the \code{SpatialExperiment} object, allowing users to exclude them from downstream analyses
to enhance data quality and reliability.
}
\examples{
library(SpotSweeper)
library(SpatialExperiment)

# load example data
spe <- STexampleData::Visium_humanDLPFC()

# Flag outlier spots
spe <- flagVisiumOutliers(spe)

# drop outlier spots
spe <- spe[, !colData(spe)$systematic_outliers]

}
