% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize_heatmap.R
\name{visualizeHeatmap}
\alias{visualizeHeatmap}
\alias{visualizeHeatmap.default}
\alias{visualizeHeatmap.SummarizedExperiment}
\title{Visualize spot values on the 2D slide}
\usage{
visualizeHeatmap(object, ...)

\method{visualizeHeatmap}{default}(
  object,
  value,
  exp_matrix = NULL,
  subset_barcodes = NULL,
  logged = TRUE,
  viridis = TRUE,
  legend_range = NULL,
  title = "",
  legend_title = NULL,
  ...
)

\method{visualizeHeatmap}{SummarizedExperiment}(
  object,
  value,
  subset_barcodes = NULL,
  logged = TRUE,
  viridis = TRUE,
  legend_range = NULL,
  title = "",
  legend_title = NULL,
  ...
)
}
\arguments{
\item{object}{A slide object created or
inherited from \code{createSlide()}, or a \code{data.frame} of slide
information with columns: barcodes, tissue, imagerow, imagecol, etc.}

\item{...}{Arguments passed to other methods}

\item{value}{(numeric vector or chr) Either a vector of numeric values for
all spots, or the name of one gene in \code{exp_matrix} or in the expression
matrix in the slide object.
In the former case, the order of values in the
vector should match the spot barcodes in the slide object.}

\item{exp_matrix}{(matrix of num) When \code{object} is a data frame and
\code{value} is a single character
string, will search the matching gene in \code{exp_matrix} and plot the gene
expression. Default: \code{NULL}}

\item{subset_barcodes}{(vector of chr) A subset of spot barcodes to plot.
By default it plots all spots in the slide object. This can be useful
when only plotting tissue spots or specific tissue types or regions.
Default: \code{NULL}}

\item{logged}{(logical) Specify if the color scale is log1p transformed.
Default: \code{TRUE}}

\item{viridis}{(logical) If true, color scale uses viridis.
Otherwise, use rainbow. Default: \code{TRUE}}

\item{legend_range}{(length 2 vector of num) Custom legend
range of the value. By default uses the range of the plotted values.
Default: \code{NULL}}

\item{title}{(chr) Title of the plot. Default: \code{""}}

\item{legend_title}{(chr) Title of the legend. Under default,
use \code{value} as legend title. Default: \code{NULL}}
}
\value{
A \code{ggplot2} object.
}
\description{
Generate and visualize spot labels on the 2D slide
as a ggplot2 object. Spot labels can be given via parameter \code{label} as
external input or one column in the \code{slide} slot of the slide
object's metadata via \code{label_col}. Exactly one of \code{label}
and \code{label_col} must be specified.
}
\examples{

data(mbrain_raw)
spatial_dir <- system.file(file.path("extdata",
                                     "V1_Adult_Mouse_Brain_spatial"),
                           package = "SpotClean")
mbrain_slide_info <- read10xSlide(tissue_csv_file=file.path(spatial_dir,
                                       "tissue_positions_list.csv"),
             tissue_img_file = file.path(spatial_dir,
                                       "tissue_lowres_image.png"),
             scale_factor_file = file.path(spatial_dir,
                                       "scalefactors_json.json"))
mbrain_obj <- createSlide(mbrain_raw,
                          mbrain_slide_info)

gp <- visualizeHeatmap(mbrain_obj, "Bc1",
                     title="mbrain", legend_title="Bc1 expression")
plot(gp)
}
