% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity_functions.R
\name{calculate_entropy}
\alias{calculate_entropy}
\title{Calculate entropy for a vector of transcript-level
expression values of one gene.}
\usage{
calculate_entropy(x, norm = TRUE, pseudocount = 0)
}
\arguments{
\item{x}{Vector of expression values.}

\item{norm}{If \code{TRUE}, the entropy values are normalized to the number
of transcripts for each gene. The normalized entropy values are always
between 0 and 1. If \code{FALSE}, genes cannot be compared to each other,
due to possibly different maximum entropy values.}

\item{pseudocount}{Pseudocount added to each transcript expression value.
Default is 0, while Laplace entropy uses a pseudocount of 1.}
}
\value{
A single gene-level entropy value.
}
\description{
Calculate entropy for a vector of transcript-level
expression values of one gene.
}
\details{
The function calculates an entropy value as part of different
diversity calculations. Given a vector of transcript-level expression values
of a gene, this function characterizes the diversity of splicing isoforms for
a gene. If there only a single transcript, the diversity value will be NaN,
as it cannot be calculated. If the expression of the given gene is 0,
the diversity value will be NA.
}
\examples{
# read counts for the transcripts of a single gene with 5 transcripts
x <- rnbinom(5, size = 10, prob = 0.4)
# calculate non-normalized naive entropy value
entropy <- calculate_entropy(x, norm = FALSE)
# calculate Laplace-entropy, also normalized for transcript number
# (the default)
norm_laplace_entropy <- calculate_entropy(x, pseudocount = 1)
}
