% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_plot_data.R
\name{make_plot_data}
\alias{make_plot_data}
\alias{makeMatrix}
\alias{makeMeanPSI}
\title{Construct data of percent-spliced-in (PSI) matrices and group-average PSIs}
\usage{
makeMatrix(
  se,
  event_list,
  sample_list = colnames(se),
  method = c("PSI", "logit", "Z-score"),
  depth_threshold = 10,
  logit_max = 5,
  na.percent.max = 0.1
)

makeMeanPSI(
  se,
  event_list = rownames(se),
  condition,
  conditionList,
  depth_threshold = 10,
  logit_max = 10
)
}
\arguments{
\item{se}{(Required) A \linkS4class{NxtSE} object generated by \link{makeSE}}

\item{event_list}{A character vector containing the names of ASE events
(as given by the \code{EventName} column of differential ASE results table
generated by one of the \link{ASE-methods}, or
the rownames of the \linkS4class{NxtSE} object)}

\item{sample_list}{(default = \code{colnames(se)}) In \code{makeMatrix()}, a list of
sample names in the given experiment to be included in the returned matrix}

\item{method}{In \code{makeMatrix()}, rhe values to be returned
(default = "PSI"). It can
alternately be "logit" which returns logit-transformed PSI values, or
"Z-score" which returns Z-score-transformed PSI values}

\item{depth_threshold}{(default = 10) Samples with the number of reads
supporting either included or excluded isoforms below this values are
excluded}

\item{logit_max}{PSI values close to 0 or 1 are rounded up/down
to \code{plogis(-logit_max)} and \code{plogis(logit_max)}, respectively. See details.}

\item{na.percent.max}{(default = 0.1) The maximum proportion of values in
the given dataset that were transformed to \code{NA} because of low splicing
depth. ASE events where there are a higher proportion (default 10\%) \code{NA}
values will be excluded from the final matrix. Most heatmap
functions will spring an error if there are too many NA values in any
given row. This option caps the number of NA values to avoid returning
this error.}

\item{condition}{The name of the column containing the condition values in
\code{colData(se)}}

\item{conditionList}{A list (or vector) of condition values of which to
calculate mean PSIs}
}
\value{
For \code{makeMatrix}: A matrix of PSI (or alternate) values, with
columns as samples and rows as ASE events.

For \code{makeMeanPSI}: A 3 column data frame, with the first column containing
\code{event_list} list of ASE events, and the last 2 columns containing the
average PSI values of the nominator and denominator conditions.
}
\description{
\code{makeMatrix()} constructs a matrix of PSI values of the given alternative
splicing events (ASEs).\cr\cr
\code{makeMeanPSI()} constructs a table of "average" PSI values, with samples
grouped by a number of given conditions (e.g. "group A" and "group B") of a
given condition category (e.g. condition "treatment").
See details below.
}
\details{
Note that this function takes the geometric mean of PSI, by first converting
all values to logit(PSI), taking the average logit(PSI) values of each
condition, and then converting back to PSI using inverse logit.

Samples with low splicing coverage (either due to insufficient sequencing
depth or low gene expression) are excluded from calculation of mean PSIs.
The threshold can be set using \code{depth_threshold}. Excluding these samples is
appropriate because the uncertainty of PSI is high when the total included /
excluded count is low. Note that events where all samples in a condition is
excluded will return a value of \code{NaN}.

Using logit-transformed PSI values is appropriate because PSI values are
bound to the (0,1) interval, and are often thought to be beta-distributed.
The link function often used with beta-distributed models is the logit
function, which is defined as \code{logit(x) = function(x) log(x / (1 - x))},
and is equivalent to \link[stats:Logistic]{stats::qlogis}. Its inverse is equivalent to
\link[stats:Logistic]{stats::plogis}.

Users wishing to calculate arithmetic means of PSI are advised to use
\link{makeMatrix}, followed by \link{rowMeans} on subsetted sample columns.
}
\section{Functions}{
\itemize{
\item \code{makeMatrix()}: constructs a matrix of PSI values of the given
alternative splicing events (ASEs)

\item \code{makeMeanPSI()}: constructs a table of "average" PSI values

}}
\examples{
se <- SpliceWiz_example_NxtSE()

colData(se)$treatment <- rep(c("A", "B"), each = 3)

event_list <- rowData(se)$EventName

mat <- makeMatrix(se, event_list[1:10])

diag_values <- makeMeanPSI(se, event_list,
  condition = "treatment", 
  conditionList = list("A", "B")
)
}
