% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plottingBasics.R
\name{plotSpatialOverlay}
\alias{plotSpatialOverlay}
\title{overlay plots}
\usage{
plotSpatialOverlay(
  overlay,
  colorBy = "sampleID",
  hiRes = TRUE,
  alpha = 1,
  legend = TRUE,
  scaleBar = TRUE,
  image = TRUE,
  fluorLegend = FALSE,
  ...,
  corner = "bottomright",
  scaleBarWidth = 0.2,
  scaleBarMicrons = NULL,
  scaleBarColor = NULL,
  scaleBarFontSize = 6,
  scaleBarLineSize = 1.5,
  textDistance = 2
)
}
\arguments{
\item{overlay}{SpatialOverlay object}

\item{colorBy}{annotation to color by}

\item{hiRes}{generated figures are either high resolution or print quickly.
Note: hiRes and outline ggplots use fill, lowRes uses color}

\item{alpha}{opacity of overlays}

\item{legend}{should legend be plotted}

\item{scaleBar}{should scale bar be plotted}

\item{image}{should image be plotted, image must be added to SpatialOverlay 
object}

\item{fluorLegend}{should viz marker on the image be added to legend}

\item{...}{additional parameters for scale bar line & text, will affect both}

\item{corner}{where in the figure should the scale bar be printed. 
Options: "bottomright"  "topright"
         "bottomleft"   "topleft"
         "bottomcenter" "topcenter"}

\item{scaleBarWidth}{percent of total figure the scale bar should take up}

\item{scaleBarMicrons}{specific microns to set scale bar at, overrides scaleBarWidth if set}

\item{scaleBarColor}{scale bar & text color}

\item{scaleBarFontSize}{font size}

\item{scaleBarLineSize}{width of line}

\item{textDistance}{text's distance from scale bar.}
}
\value{
gp
}
\description{
overlay plots
}
\note{
hiRes and outline ggplots use fill, lowRes uses color
}
\examples{

muBrain <- readRDS(unzip(system.file("extdata", "muBrainSubset_SpatialOverlay.zip",
                                    package = "SpatialOmicsOverlay")))
                             
plotSpatialOverlay(overlay = muBrain, legend = FALSE,  
                   hiRes = FALSE, scaleBar = FALSE)

}
