% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xmlParsing.R
\name{parseOverlayAttrs}
\alias{parseOverlayAttrs}
\title{Parse the xml file for AOI attributes in GeoMx images}
\usage{
parseOverlayAttrs(omexml, annots, labworksheet, ...)
}
\arguments{
\item{omexml}{xml file from OME-TIFF, can provide path to OME-TIFF and xml 
will automatically be extracted}

\item{annots}{df of annotations}

\item{labworksheet}{annots are from lab worksheet file}

\item{...}{segCol in annotMatching, if auto detection doesn't work.}
}
\value{
SpatialPosition of AOIs containing metadata and base64encoded positions
}
\description{
Parse the xml file for AOI attributes in GeoMx images
}
\examples{

image <- downloadMouseBrainImage()

xml <- xmlExtraction(ometiff = image)

muBrainLW <- system.file("extdata", "muBrain_LabWorksheet.txt", 
                         package = "SpatialOmicsOverlay")

muBrainLW <- readLabWorksheet(muBrainLW, slideName = "D5761 (3)")

overlay <- parseOverlayAttrs(omexml = xml, 
                             annots = muBrainLW, 
                             labworksheet = TRUE)

}
