% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordinateGeneration.R
\name{moveCoords}
\alias{moveCoords}
\title{Move coordinates if they don't match image}
\usage{
moveCoords(overlay, direction = "right")
}
\arguments{
\item{overlay}{SpatialOverlay object}

\item{direction}{which direction should coordinates move: left, right, up, down}
}
\value{
SpatialOverlay object
}
\description{
If generated coordinates do not match the image use this 
function to move coordinates. Coordinates are only changed 1 pixel at a time.
}
\examples{

muBrain <- readRDS(unzip(system.file("extdata", "muBrainSubset_SpatialOverlay.zip", 
                                    package = "SpatialOmicsOverlay")))
head(coords(muBrain), 3)
head(coords(moveCoords(muBrain, direction = "up")), 3)                                    

}
