% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometry_operation.R
\name{crop}
\alias{crop}
\title{Crop an SFE object with a geometry}
\usage{
crop(
  x,
  y = NULL,
  colGeometryName = 1L,
  sample_id = "all",
  op = st_intersection,
  keep_whole = "none",
  cover = FALSE
)
}
\arguments{
\item{x}{An SFE object.}

\item{y}{An object of class \code{sf}, \code{sfg}, \code{sfc} with which to
crop the SFE object, or a bounding box with the format of the output of
\code{\link{bbox,SpatialFeatureExperiment-method}}.}

\item{colGeometryName}{Column geometry to used to indicate which cells/spots
to keep.}

\item{sample_id}{Samples to crop. Optional when only one sample is present.
Can be multiple samples, or "all", which means all samples. For multiple
samples, \code{sf} data frame \code{y} may have column \code{sample_id}
indicating which geometry subsets which sample or matrix \code{y} may
indicate sample specific bounding boxes in its column names. Only samples
included in the indicated sample IDs are subsetted. If sample is not
indicated in \code{y}, then the same geometry or bounding box is used to
subset all samples specified in the \code{sample_id} argument.}

\item{op}{A geometric operation function to crop the geometries in the SFE
object. Only \code{\link[sf]{st_intersection}} and \code{\link[sf]{st_difference}}
are allowed. If "intersection", then only things inside \code{y} is kept
after cropping. If "difference", then only things outside \code{y} is kept.}

\item{keep_whole}{Character vector, can be one or more of "col" and "annot"
to keep whole items from \code{colGeometries} or \code{annotGeometries},
keeping geometries that partially intersect with \code{y} whole. This can
greatly speed up code while not breaking geometries into multiple pieces.
Can also be "none" so all geometries are actually cropped.}

\item{cover}{Logical, whether the geometries in \code{x} must be entirely
covered by \code{y} if \code{op = st_intersection} or whether \code{x} must
be entirely outside \code{y} if \code{op = st_difference}. Only relevant
when \code{keep_whole != "none"}.}
}
\value{
An SFE object. There is no guarantee that the geometries after
  cropping are still all valid or preserve the original geometry class.
}
\description{
Returns an SFE object whose specified \code{colGeometry} returns \code{TRUE}
with a geometric predicate function (usually intersects) with another
geometry of interest. This can be used to subset an SFE object with a tissue
boundary or histological region polygon, or crop away empty spaces. After
cropping, not only will the cells/spots be subsetted, but also all geometries
will be cropped.
}
\details{
3D geometries are allowed, but geometric operations can only be performed in
x and y but not z.
}
\examples{
library(SFEData)
sfe <- McKellarMuscleData("small")
# Subset sfe to only keep spots on tissue
sfe_on_tissue <- crop(sfe, tissueBoundary(sfe),
    colGeometryName = "spotPoly",
    sample_id = "Vis5A"
)
}
\concept{Geometric operations}
