% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveRDS.R
\name{containsOutOfMemoryData,SpatialFeatureExperiment-method}
\alias{containsOutOfMemoryData,SpatialFeatureExperiment-method}
\title{Whether an SFE object contains out of memory data}
\usage{
\S4method{containsOutOfMemoryData}{SpatialFeatureExperiment}(object)
}
\arguments{
\item{object}{An SFE object}
}
\value{
TRUE or FALSE
}
\description{
Out of memory data, such as \code{DelayedArray}, some \code{SpatRasterImage}
objects, and \code{BioFormatsImage}, will break if saved as RDS. This method
of \code{\link[BiocGenerics]{containsOutOfMemoryData}} checks if an SFE 
object has out of memory data, specifically the images. Having out of memory
data will result into an error when \code{saveRDS} is called; we recommend
using the \code{alabaster.sfe} package instead.
}
\examples{
outdir <- system.file("extdata", package = "SpatialFeatureExperiment")
samples <- file.path(outdir, paste0("sample0", 1:2))
sfe <- read10xVisiumSFE(samples, type = "sparse", data = "filtered")
containsOutOfMemoryData(sfe)
}
\concept{Utilities}
