% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runCollapseCellTypes.R
\name{runCollapseCellTypes}
\alias{runCollapseCellTypes}
\alias{runCollapseCellTypes,NanoStringGeoMxSet-method}
\title{Run collapseCellTypes}
\usage{
runCollapseCellTypes(object, ...)

\S4method{runCollapseCellTypes}{NanoStringGeoMxSet}(object, matching = NULL)
}
\arguments{
\item{object}{An S4 object such as a GeoMxSet object}

\item{...}{Arguments passed to collapseCellTypes}

\item{matching}{A list object holding the mapping from beta's cell names to
official cell names.
 See str(safeTME.matches) for an example.}
}
\value{
A reshaped deconvolution result object
}
\description{
Runs collapseCellTypes from an S4 object

Given the input of an SpatialDecon result output and a list of which cell
types to combine,
 returns a reshaped deconvolution result object with the specified cell
 types merged.
}
\examples{
library(GeomxTools)
datadir <- system.file("extdata", "DSP_NGS_Example_Data", package = "GeomxTools")
demoData <- readRDS(file.path(datadir, "/demoData.rds"))

demoData <- shiftCountsOne(demoData)
target_demoData <- aggregateCounts(demoData)

target_demoData <- normalize(target_demoData, "quant")
                
# run basic decon:
res0 <- runspatialdecon(object = target_demoData,
                        norm_elt = "exprs_norm",
                        raw_elt = "exprs")

# run reverse decon:
target_demoData <- runReverseDecon(object = target_demoData,
                                   norm_elt = "exprs_norm",
                                   beta = pData(res0)$beta)

}
