% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpatialCPie.R
\name{.arrayPlot}
\alias{.arrayPlot}
\title{Array pie plot}
\usage{
.arrayPlot(scores, coordinates, counts = NULL, image = NULL,
  scoreMultiplier = 1, spotScale = 1, spotOpacity = 1,
  numTopGenes = 5)
}
\arguments{
\item{scores}{\code{\link[base]{data.frame}} with cluster scores for each
spot containing the columns \code{"spot"}, \code{"name"}, and \code{"score"}.}

\item{coordinates}{\code{\link[base]{data.frame}} with \code{rownames} matching
those in \code{scores} and columns \code{"x"} and \code{"y"} specifying the plotting
position of each observation.}

\item{image}{a \code{\link[grid]{grid.grob}} to use as background to the
plots.}

\item{scoreMultiplier}{log multiplication factor applied to the score vector.}

\item{spotScale}{pie chart size.}

\item{spotOpacity}{pie chart opacity.}
}
\value{
\code{\link[ggplot2]{ggplot}} object of the pie plot.
}
\description{
Array pie plot
}
\keyword{internal}
