% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialQCPlots.R
\name{plotZoomFovsMap}
\alias{plotZoomFovsMap}
\title{plotZoomFovsMap}
\usage{
plotZoomFovsMap(
  spe,
  fovs = NULL,
  mapPointCol = "darkmagenta",
  mapNumbersCol = "black",
  mapAlphaNumbers = 0.8,
  title = NULL,
  ...
)
}
\arguments{
\item{spe}{A `SpatialExperiment` object containing spatial transcriptomics
data.}

\item{fovs}{A character vector specifying the FOVs to be zoomed in and
plotted. Must match values in the `fov` column of `colData(spe)`.}

\item{mapPointCol}{A character string specifying the color of the points
in the map. Default is `"darkmagenta"`.}

\item{mapNumbersCol}{A character string specifying the color of the
numbers on the map. Default is `"black"`.}

\item{mapAlphaNumbers}{A numeric value specifying the transparency of the
numbers on the map. Default is `0.8`.}

\item{title}{An optional character string specifying the title of the final
plot. If `NULL`, no title is added. Default is `NULL`.}

\item{...}{Additional arguments passed to `plotPolygons`.}
}
\value{
A combined plot showing a map of all FOVs with zoomed-in views of
the specified FOVs and their associated polygons.
}
\description{
Plot Zoomed-in FOVs with Map and Polygons

This function generates a plot that shows a map of all fields of view (FOVs)
within a `SpatialExperiment` object, alongside a zoomed-in view of the
specified FOVs with an overlay of polygons and optional coloring.
}
\details{
The function first filters the `SpatialExperiment` object to the
specified FOVs, generates a plot of the cells for the entire map, then
creates a detailed polygon plot of the selected FOVs, and finally combines
these into a single side-by-side visualization. If `title` is not `NULL`, it
adds a title to the combined plot.
}
\examples{
example(readAndAddPolygonsToSPE)
plotZoomFovsMap(spe, fovs=16, title="FOV 16")
}
