% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getInteractingGenes.R
\name{find_pattern_hotspots}
\alias{find_pattern_hotspots}
\title{Identify hotspots of spatial pattern influence}
\usage{
find_pattern_hotspots(
  spPatterns,
  params = NULL,
  patternName = "Pattern_1",
  outlier = "positive",
  nullSamples = 1000,
  includeSelf = TRUE,
  ...
)
}
\arguments{
\item{spPatterns}{A data frame that contains the spatial coordinates
and metrics for spatial features (cell types/cell processes). The column
names must include 'x' and 'y' as well as the spatially varying features.}

\item{params}{a named vector of the optimal sigma and threshold for a
given spatial pattern. The names are should be 'sigmaOpt' and 'threshOpt'.
The default value is NULL.}

\item{patternName}{a character string that specifies the pattern of
interest}

\item{outlier}{a character string specifying whether to apply the
outlier threshold to the kernel density distribution in a one-sided manner
(specify 'positive' the default) or in a two sided manner (specify
'two.sided').}

\item{nullSamples}{a numeric values specifying the number of spatial patterns
to randomly sample for a null distribution.}

\item{includeSelf}{a logic value specifying whether to consider the
spatial influence the pattern has on surrounding regions only (set to FALSE),
or whether to also consider the influence of the pattern itself (set to TRUE
, the default).}

\item{...}{Arguments passed to methods}
}
\value{
a character vector with the spatial feature name if the spatial
influence exceeded the threshold for that spot/cell, and NA otherwise
}
\description{
This function calculates 'hotspots' which are regions of high
spatial influence based on an outlier threshold from a null distribution.
}
\examples{
library(SpaceMarkers)
#Visium data links
urls <- read.csv(system.file("extdata","visium_data.txt",
                           package="SpaceMarkers",mustWork = TRUE))
sp_url <- urls[["visium_url"]][2]
#Remove present Directories if any
unlink(basename(sp_url))
unlink("spatial", recursive = TRUE)
#Obtaining CoGAPS Patterns i.e Spatial Features
cogaps_result <- readRDS(system.file("extdata","CoGAPS_result.rds",
                                   package="SpaceMarkers",mustWork = TRUE))
spFeatures <- slot(cogaps_result,"sampleFactors")
#Obtaining Spatial Coordinates
download.file(sp_url, basename(sp_url), mode = "wb")
untar(basename(sp_url))
spCoords <- load10XCoords(visiumDir = ".", version = "1.0")
rownames(spCoords) <- spCoords$barcode
#Match Dimensions
barcodes <- intersect(rownames(spFeatures),spCoords$barcode)
spCoords <- spCoords[barcodes,]
spFeatures <- spFeatures[barcodes,]
spPatterns <- cbind(spCoords,spFeatures[barcodes,])
spPatterns<-spPatterns[c("barcode","y","x","Pattern_1","Pattern_5")]
data("optParams")
hotspots <- find_pattern_hotspots(
spPatterns = spPatterns,
patternName = "Pattern_1",
params = optParams[,"Pattern_1"],
outlier = "positive",nullSamples = 1000,includeSelf = TRUE)
#Remove present Directories if any
unlink(basename(sp_url))
unlink("spatial", recursive = TRUE)

}
\seealso{
Other getIntGenes: 
\code{\link{get_interacting_genes}()},
\code{\link{get_pairwise_interacting_genes}()}
}
\concept{getIntGenes}
