% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinase_activity.R
\name{plotKinaseTimeSeries}
\alias{plotKinaseTimeSeries}
\title{Plot Kinase Activity Time Series}
\usage{
plotKinaseTimeSeries(scoreTab, pCut = 0.05, clusterName = "cluster1")
}
\arguments{
\item{scoreTab}{A \code{data frame} containing kinase activity scores,
p-values, and time points.}

\item{pCut}{A \code{numeric} value specifying the p-value threshold for
significance. Default is 0.05.}

\item{clusterName}{A \code{character} string specifying the name of the
cluster for the plot title. Default is "cluster1".}
}
\value{
A \code{ggplot2} object representing the heatmap of kinase activity
score.
}
\description{
\code{plotKinaseTimeSeries} creates a heatmap to visualize the result of
kinase activity inference for time-series clustering, with significant
activity changes marked.
}
\details{
The heatmap shows kinase activity scores over different time points.
Significant activities (based on the specified p-value threshold) are
marked with an asterisk (*). The color gradient represents the activity
score, with blue indicating low activity, red indicating high activity, and
white as the midpoint.
}
\examples{
# Example usage:
scoreTab <- data.frame(
 timepoint = rep(c("0h", "1h", "2h"), each = 3),
 source = rep(c("KinaseA", "KinaseB", "KinaseC"), times = 3),
 score = runif(9, -2, 2),
 p_value = runif(9, 0, 0.1)
)
plotKinaseTimeSeries(scoreTab)

}
