% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataImport.R
\name{normByFullProteome}
\alias{normByFullProteome}
\title{Normalize Phosphoproteome by Full Proteome}
\usage{
normByFullProteome(mae, replace = TRUE)
}
\arguments{
\item{mae}{A \code{MultiAssayExperiment} object containing both
phosphoproteome and proteome assays.}

\item{replace}{\code{Logical}, whether to replace the existing
phosphoproteome assay in the \code{MultiAssayExperiment} object. If
replace = \code{FALSE}, a new assay, phosphoRatio, will be created.
Default is \code{TRUE}.}
}
\value{
A \code{MultiAssayExperiment} object with the normalized
phosphoproteome data.
}
\description{
\code{normByFullProteome} normalizes the phosphoproteome data by the
corresponding full proteome data in a \code{MultiAssayExperiment} object.
The "Phosphoproteome" assay
in the MultiAssayExperiment will be replaced by the ratio.
}
\details{
The function performs the following steps:
\itemize{
  \item Checks if both phosphoproteome and proteome assays are present in
  the \code{MultiAssayExperiment} object.
  \item Extracts the phosphoproteome and proteome assays along with the
  sample annotations.
  \item Matches the samples between the phosphoproteome and proteome assays.
  \item Normalizes the phosphoproteome data by dividing it by the
  corresponding proteome data.
  \item Replaces the phosphoproteome assay in the \code{MultiAssayExperiment}
  object or adds the normalized data as a new assay, depending on the
  \code{replace} parameter.
}
}
\examples{
# load mae object
data("dia_example")
# call the function
normByFullProteome(dia_example)

}
