% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulator.R
\name{save_simulation}
\alias{save_simulation}
\title{Save the expression matrix of a simulated pseudo-bulk dataset to a file}
\usage{
save_simulation(simulation, filename, assay = "bulk_counts")
}
\arguments{
\item{simulation}{the result of simulate_bulk()}

\item{filename}{the filename where to save the expression matrix to}

\item{assay}{name of the assay in simulation to save, default to bulk_counts}
}
\value{
write a file
}
\description{
Save the expression matrix of a simulated pseudo-bulk dataset to a file
}
\examples{
counts <- Matrix::Matrix(matrix(stats::rpois(3e5, 5), ncol = 300), sparse = TRUE)
tpm <- Matrix::Matrix(matrix(stats::rpois(3e5, 5), ncol = 300), sparse = TRUE)
tpm <- Matrix::t(1e6 * Matrix::t(tpm) / Matrix::colSums(tpm))

colnames(counts) <- paste0("cell_", rep(1:300))
colnames(tpm) <- paste0("cell_", rep(1:300))
rownames(counts) <- paste0("gene_", rep(1:1000))
rownames(tpm) <- paste0("gene_", rep(1:1000))

annotation <- data.frame(
  "ID" = paste0("cell_", rep(1:300)),
  "cell_type" = c(
    rep("T cells CD4", 50),
    rep("T cells CD8", 50),
    rep("Macrophages", 100),
    rep("NK cells", 10),
    rep("B cells", 70),
    rep("Monocytes", 20)
  )
)

dataset <- SimBu::dataset(
  annotation = annotation,
  count_matrix = counts,
  tpm_matrix = tpm,
  name = "test_dataset"
)

s <- SimBu::simulate_bulk(dataset,
  scenario = "even",
  scaling_factor = "NONE",
  nsamples = 10,
  ncells = 100
)

save_simulation(s, tempfile())
}
