% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decomposeQP.R
\name{decomposeQP}
\alias{decomposeQP}
\title{decomposeQP function}
\usage{
decomposeQP(m, P, ...)
}
\arguments{
\item{m}{observed tumor profile vector for a single patient/sample, 96 by 1. 
m is normalized.}

\item{P}{signature profile matrix, 96 by N (N = # signatures, COSMIC: N=30)}

\item{...}{control parameter that can be passed into the solve.QP 
function}
}
\value{
matrix containing estimated signature exposures
}
\description{
This function is taken from the package 'SignatureEstimation' by Xiaoqing 
Huang and Damian Wojtowicz 
(source: https://www.ncbi.nlm.nih.gov/CBBresearch/Przytycka/index.cgi#signatureestimation)
The function allows to get the optimal solution by using dual method to solve
the quadratic programming problem.
}
\examples{
data(cosmicSigs)
mut_cat<- (create_mut_catalogues(1,500)[['catalogues']])/500
decomposeQP(mut_cat, cosmicSigs)
}
