% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_mut_catalogues.R
\name{bootstrap_mut_catalogues}
\alias{bootstrap_mut_catalogues}
\title{Bootstraps a given mutational catalogue}
\usage{
bootstrap_mut_catalogues(n, original, m = NULL)
}
\arguments{
\item{n}{Amount of bootstrapped replicates that are created (they will by
default have the same amount of mutations as the original catalogue)}

\item{original}{Mutational catalogue (matrix) of a sample that is taken as
the distribution from which the replicates are sampled}

\item{m}{Amount of mutations the replicates are supposed to have
(e.g. if this differs from the original or if the original is provided as
probabilities instead of total counts)}
}
\value{
matrix containing the mutational catalogues of the replicates
}
\description{
Bootstraps a given mutational catalogue  by replicating samples from the
original catalogue's distribution of mutational features. The output can be
input to signature_exposure.
}
\examples{
data(cosmicSigs)
reps <- bootstrap_mut_catalogues(n = 150, original = create_mut_catalogues(
                                  10, 500)[["catalogues"]][,1])

}
