% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/is.shared.R
\name{is.shared}
\alias{is.shared}
\alias{is.shared,ANY-method}
\title{Test whether an object is shared}
\usage{
is.shared(x, ..., depth = 0, showAttributes = FALSE)

\S4method{is.shared}{ANY}(x, ..., depth = 0, showAttributes = FALSE)
}
\arguments{
\item{x}{An R object}

\item{...}{For generalization purpose only}

\item{depth}{Whether to recursively check the element of \code{x}. This parameter
only works for container objects(e.g. \code{list} and \code{environment}), see details.}

\item{showAttributes}{Whether to check the attributes of \code{x}, default \code{FALSE}.}
}
\value{
a single logical value or a list.
}
\description{
Test whether an object is shared
}
\details{
When \code{depth=0}, the \code{is.shared} function return a single logical value indicating
whether \code{x} is shared or contains any shared objects. When \code{depth>0} and \code{x} is a
container(e.g. \code{list}), the function will recursively check each element of \code{x} and
return a list with each elements corresponding to the elements in \code{x}.
The \code{depth} parameter determines the depth of the checking procedure.

if \code{showAttributes = TRUE}, the attributes of the object will also be checked. The
check result is returned as attributes of the return value by appending \code{Shared} to the
end of the original attribute names. Note that \code{showAttributes} has
no effect on an S4 object for the attributes of an S4 object are used to store the
slots and should not be treated as the attributes of an object.
}
\examples{
x1 <- share(1:10)
is.shared(x1)

x2 <- share(list(a=1:10, b = list(d = letters, e = runif(10))))
is.shared(x2, depth=0)
is.shared(x2, depth=0, showAttributes = TRUE)
is.shared(x2, depth=1)
is.shared(x2, depth=2)
}
