% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SharedObject.R
\name{SharedObject}
\alias{SharedObject}
\title{Create an empty shared object}
\usage{
SharedObject(
  mode = c("raw", "logical", "integer", "numeric", "complex"),
  length,
  attrib = list(),
  ...
)
}
\arguments{
\item{mode}{the type of the shared object}

\item{length}{the length of the shared object}

\item{attrib}{the attributes of the shared object}

\item{...}{Parameters that is used to create the shared object, please
refer to \code{?share} for details.}
}
\value{
An R vector
}
\description{
Create an empty shared object with a specific length and attributes.
}
\examples{
## Create an empty shared vector
x1 <- SharedObject(mode = "numeric", length = 10)
x1
## Create an empty shared matrix
x2 <- SharedObject(mode = "numeric", length = 6,
                 attrib = list(dim = c(2L,3L)))
x2
}
