% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotQC.R
\name{plotQC}
\alias{plotQC}
\title{Plot the QC results for specific QC steps.}
\usage{
plotQC(
  seqfile,
  QCstep = c("MissingRate", "SexCheck", "Inbreeding", "IBD", "PCA"),
  interactive = FALSE,
  sdcoef = 5,
  pc1 = "EV1",
  pc2 = "EV2",
  pairedScatter = FALSE,
  ...
)
}
\arguments{
\item{seqfile}{SeqSQC object with QC results.}

\item{QCstep}{which QC step the user want to do plotting. Takes
values of \code{c("MissingRate", "SexCheck", "Inbreeding",
"IBD", "PCA")}}

\item{interactive}{whether to generate interactive plot. Recommend
to use \code{interactive = TRUE} if user perform sample QC
using an rmarkdown script and output plot to html format.}

\item{sdcoef}{for inbreeding outlier check, how many standard
deviation we need for identification of inbreeding
outliers. The default is 5.}

\item{pc1}{the eigenvector on x axis for PCA result. The default is
"EV1" for eigenvector 1.}

\item{pc2}{the eigenvector on y axis for PCA result. The default is
"EV2" for eigenvector 2.}

\item{pairedScatter}{for PCA result, whether to plot the paired
scatterplot for the first 4 PC axes.}

\item{...}{Arguments to be passed to other methods.}
}
\value{
the ggplot or interactive plot (if output is in html
    format) for specific QC result. If "interactive=FALSE", it
    returns a ggplot and author could have the flexibility to add
    on any layers, scales, faceting specifications and coordinate
    systems.
}
\description{
Plot QC results.
}
\examples{
load(system.file("extdata", "example.seqfile.Rdata", package="SeqSQC"))
gfile <- system.file("extdata", "example.gds", package="SeqSQC")
seqfile <- SeqSQC(gdsfile = gfile, QCresult = QCresult(seqfile))
p <- plotQC(seqfile, QCstep="PCA", interactive=FALSE)
p
}
\author{
Qian Liu \email{qliu7@buffalo.edu}
}
